run /home/oliver/Forschung/OutsideOption/data/init.do
use auction200505,clear
keep if Treatment == bidtreatment
drop if pilot == 1
drop if sessiontype == 4
drop if x != 50
drop if plus == 0
egen myid = fill(1 2)
drop if Type==4
preserve
collapse (median) datenew,by(date sid SessionID second sessiontype kurs showupfee)
collapse (count) sid,by (date datenew SessionID second sessiontype kurs showupfee)
sort  second sessiontype date
decode sessiontype,gen(st)
gen sf="second price" if second
replace sf="first price" if !second
replace st=substr(st,1,1)
gen type="none" if st=="A"
replace type="public" if st=="B"
replace type="private" if st=="C"
replace st=st+"1" if !second
replace st=st+"2" if second
texlist date st type sf kurs sid
restore
drop bid_x*
keep sessiontype second indepobs sid Period bid_* oo
egen sp=group(Period sid)
reshape long bid_,i(sp) j(v)
rename bid_ bid
save ootmp,replace

run /home/oliver/Forschung/OutsideOption/data/init.do
use ootmp,replace
psline bid v if sessiontype==1 & !second , n(4) width(200) nolimits
psline bid v if sessiontype==1 &  second , n(4) width(200) nolimits
*----------------------------------------
run /home/oliver/Forschung/OutsideOption/data/init.do
use ootmp,replace
keep if sessiontype==2
gen optBid=25+v/2-oo
mypsline optBid v oo , b(3)
mypsline bid v oo , nolimits b(3)
mypsline optBid oo v , b(3)
mypsline bid oo v , nolimits b(3)
*----------------------------------------
run /home/oliver/Forschung/OutsideOption/data/init.do
use ootmp,replace
keep if sessiontype==3 & !second
gen x=v-oo
gen optBid=2*x/3
replace optBid=(100*x*x-2*x*x*x/3-250000/3)/(200*x-x*x-5000) if x>50
mypsline optBid v oo 
mypsline bid v oo , nolimits
mypsline optBid oo v 
mypsline bid oo v , nolimits
*----------------------------------------
run /home/oliver/Forschung/OutsideOption/data/init.do
use ootmp,replace
keep if sessiontype==3 & second
gen x=v-oo
gen optBid=x
mypsline optBid v oo
mypsline bid v oo , nolimits
mypsline optBid oo v
mypsline bid oo v , nolimits
*----------------------------------------
run /home/oliver/Forschung/OutsideOption/data/init.do
use ootmp,replace
replace oo=0 if oo==.
gen eqbid=25+v/2 if sessiontype==1
replace eqbid=25+v/2-oo if sessiontype==2
gen x=(v-oo)
replace eqbid=2*x/3 if sessiontype==3 & x<=50
replace eqbid=(100*x*x-2*x*x*x/3-250000/3)/(200*x-x*x-5000) if sessiontype==3 & x>50
replace eqbid=x if second
reg bid v if sessiontype==1 & !second,cluster(indepobs)
reg bid v oo if sessiontype==2 & !second,cluster(indepobs)
reg bid v oo if sessiontype<3 & !second,cluster(indepobs)
test v==.5
gen x=v-oo
gen eqbidW=eqbid*oo
gen Delta=eqbid-2*x/3
reg bid eqbid oo eqbidW if sessiontype==3 & !second,cluster(indepobs)
reg bid v oo Delta if sessiontype==3 & !second,cluster(indepobs)
test v=2/3
test oo=-2/3
test Delta==1
test v=-oo
reg bid v if sessiontype==1 & second,cluster(indepobs)
gen dA=(sessiontype==1)
gen vA=v*dA
replace v=v*(1-dA)
reg bid v vA oo dA if second,cluster(indepobs)
test v==vA
reg bid v oo if sessiontype==3 & second,cluster(indepobs)
test v=1
test oo=-1
gen v3=v * (sessiontype==3)
gen oo3=oo * (sessiontype==3)
gen Delta3=Delta * (sessiontype==3 & second)
gen eqbid1=eqbid * (sessiontype==1)
gen eqbid2=eqbid * (sessiontype==2)
gen eqbid3=(2/3)*(v-oo) * (sessiontype==3)
replace eqbid3=eqbid if (sessiontype==3 & second)
reg bid  eqbid1 eqbid2 eqbid3  Delta3 if !second,noconstant cluster(indepobs)
test eqbid1 = 1
test eqbid1 = eqbid2
test eqbid2 = eqbid3
test Delta3 = 1 
reg bid  eqbid1 eqbid3  if second,noconstant cluster(indepobs)
test eqbid1=1
test eqbid3=eqbid1
*----------------------------------------
* revenue *
run /home/oliver/Forschung/OutsideOption/data/init.do
* we generate 100 hypothetical auctions for each bidder and period:
set obs 100
set seed 20040905
gen ii=_n
save tmp,replace
*
use auction200505,clear
keep if Treatment == bidtreatment
drop if pilot == 1
drop if sessiontype == 4
drop if x != 50
drop if plus == 0
drop if Type==4
drop x
replace oo=0 if oo==.
drop bid_x*
keep sid indepobs Period Group bid_* plus second sessiontype oo
compress
cross using tmp
egen igr=group(indepobs Period ii Group)
sort igr
list sid Group in 1/10

gen v=uniform()*50+50
* determine own bid:
gen bid=.
foreach low of numlist 50(10)90 {
local high=`low'+10
display "`low' `high'"
replace bid=(v-`low')*(bid_`high'-bid_`low')/10+bid_`low' if v>=`low' & v<=`high'
}
*twoway scatter bid v if sid==105 & Period==1
*showgraph
gen efgain=v-oo
sum efgain
gen eqbid=25+v/2 if sessiontype==1
replace eqbid=25+v/2-oo if sessiontype==2
gen x=(v-oo)
replace eqbid=2*x/3 if sessiontype==3 & x<=50
replace eqbid=(100*x*x-2*x*x*x/3-250000/3)/(200*x-x*x-5000) if sessiontype==3 & x>50
replace eqbid=x if second
*twoway scatter eqbid v if sid==33
*showgraph
* find the opponent's bidding function:
foreach name in bid eqbid efgain {
  gen     o`name'=`name'[_n-1] if igr==igr[_n-1]
  replace o`name'=`name'[_n+1] if igr==igr[_n+1]
}
drop revenue
generate revenue=obid
replace  revenue= bid if (bid>obid &  !second) | (bid<obid & second)
generate eqrevenue=oeqbid
replace  eqrevenue= eqbid if (eqbid>oeqbid &  !second) | (eqbid<oeqbid & second)
gen meff=(oefgain+efgain)/2
gen eff=oefgain-meff
replace eff=efgain-meff if bid>obid
gen eqeff=oefgain-meff
replace eqeff=efgain-meff if eqbid>oeqbid
gen ieff=eff>0
gen eqieff=eqeff>0
gen drev=revenue-eqrevenue
save revsimoo,replace

clear
set memory 400M
use revsimoo,clear
tabstat drev ieff eqieff if !second ,by(sessiontype) 
tabstat drev ieff eqieff if  second ,by(sessiontype)
gen A1=(sessiontype==1 & !second)
gen A2=(sessiontype==1 &  second)
gen B1=(sessiontype==2 & !second)
gen C1=(sessiontype==3 & !second)
gen C2=(sessiontype==3 &  second)
reg drev A1 A2 B1 C1 C2,noconstant cluster(indepobs)
test A1 = A2
test C1 = C2
test A1-A2 = C1-C2
test C1=B1
test C1=A1
reg ieff A1 A2 B1 C1 C2,noconstant cluster(indepobs)
test A1=C1
test A1=A2
test C1=C2
logit ieff A1 A2 B1 C1 C2,noconstant cluster(indepobs)
test A1=C1
