#
# monoBid - creates an equivalent monotonic function:
monoBid <- function(bid,val=c(50,60,70,80,90,100)) {
  width<-c(val[-1],NA)-val
  lbid<-bid
  rbid<-c(bid[-1],NA)
  minObid<-pmin(lbid,rbid)
  maxObid<-pmax(lbid,rbid)
  sbids <- sort(unique(bid))
  nbids <- length(sbids)
  xx <- as.data.frame(cbind(width,minObid,maxObid))[-length(bid),]
  if (nbids>1) ox <- merge(xx,cbind(minB = sbids[-nbids],maxB = sbids[-1]),all=TRUE)
  else ox <- merge(xx,cbind(minB = sbids,maxB = sbids),all=TRUE)
  ox <- within(ox,share<-ifelse(maxObid==minObid,1,(maxB-minB)/(maxObid-minObid)) * width * (minB>=minObid & maxB<=maxObid))
  ox <- with(ox,aggregate(ox$share,list(minObid=minB,maxObid=maxB),sum))
  names(ox)[3]<-c("width")
  ox
}
#
# mmVals - translates a bidding function into "stripes"
mmVals <- function(bid,val=c(50,60,70,80,90,100)) {
  lbid<-bid
  rbid<-c(bid[-1],NA)
  lval<-val
  rval<-c(val[-1],NA)
  minBid<-pmin(lbid,rbid)
  maxBid<-pmax(lbid,rbid)
  as.data.frame(cbind(lbid,rbid,lval,rval,minBid,maxBid))[-length(bid),]
}
#
# C: critical range, we `might' win between minCval..maxCval
# A: own bid is larger than maxObid , we will win between  minAval..maxAval

payMat <- function(bothBids,sum=FALSE) {
  xx <- within(bothBids,{
    lcritObid <- pmin(pmax(minObid,minBid),maxBid)
    rcritObid <- pmax(pmin(maxObid,maxBid),minBid)
    rAval <- lval+(maxBid-lbid)*(rval-lval)/(rbid-lbid)
    rCval <- lval+(rcritObid-lbid)*(rval-lval)/(rbid-lbid)
    lCval <- lval+(lcritObid-lbid)*(rval-lval)/(rbid-lbid)
    minAval <- pmin(rAval,rCval)
    maxAval <- pmax(rAval,rCval)
    minCval <- pmin(rCval,lCval)
    maxCval <- pmax(rCval,lCval)
    cPay <- ifelse(maxObid==minObid,0,(1 / (rval - lval) * (rbid - lbid) * width / (maxObid - minObid) * (1 - 1 / (rval - lval) * (rbid - lbid)) * (maxCval ^ 3 - minCval ^ 3)) / 0.3e1 + (((-lval / (rval - lval) * (rbid - lbid) + lbid - minObid) * width / (maxObid - minObid) * (1 - 1 / (rval - lval) * (rbid - lbid)) + 1 / (rval - lval) * (rbid - lbid) * width / (maxObid - minObid) * (lval / (rval - lval) * (rbid - lbid) - lbid)) * (maxCval ^ 2 - minCval ^ 2)) / 0.2e1 + ((-lval / (rval - lval) * (rbid - lbid) + lbid - minObid) * width / (maxObid - minObid) * (lval / (rval - lval) * (rbid - lbid) - lbid) * (maxCval - minCval)));
    aPay <- (width * (1 - 1 / (rval - lval) * (rbid - lbid)) * (maxAval ^ 2 - minAval ^ 2)) / 0.2e1 + (width * (lval / (rval - lval) * (rbid - lbid) - lbid) * (maxAval - minAval));
  })
  if(sum) with(xx,sum(cPay)+sum(aPay))
  else xx
}

#
# equilibrium bids (w0=smallest valuation,w1=largest for weak bidder, w2=largest for strong bidder,
# all valuations are uniformly distributed
eqWeak <- function(x,w1,w2)  ifelse(w1==w2,x/2,ifelse(x==0,0,-w1 ^ 2 * w2 ^ 2 * (-0.1e1 + sqrt(-(-w1 ^ 2 * w2 ^ 2 + x ^ 2 * w2 ^ 2 - x ^ 2 * w1 ^ 2) / w1 ^ 2 / w2 ^ 2)) / (w2 ^ 2 - w1 ^ 2) / x));
eqStrong <- function(x,w1,w2) ifelse(w1==w2,x/2,ifelse(x==0,0,w1 ^ 2 * w2 ^ 2 * (-0.1e1 + sqrt((w1 ^ 2 * w2 ^ 2 + x ^ 2 * w2 ^ 2 - x ^ 2 * w1 ^ 2) / w1 ^ 2 / w2 ^ 2)) / (w2 ^ 2 - w1 ^ 2) / x));
#
myStep <- function (file,i=0,alpha=.5,ndeps=1e-4,alternate=TRUE) {
  cweak<-list(ndeps=rep(ndeps,length(weakBid)))
  cstrong<-list(ndeps=rep(ndeps,length(strongBid)))
  weakBR <- optim(par=weakEqBid,fn=function(x) -payMat(merge(mmVals(c(0,x),weakVal),monoBid(c(0,strongBid),strongVal)),sum=TRUE),method="BFGS",control=cweak)
  weakEps<-sum(weakBR$par-weakBid)^2
  if (alternate) weakBid <<- alpha*pmin(weakVal[-1],pmax(weakBR$par,0))+(1-alpha)*weakBid
  strongBR <-optim(par=strongEqBid,fn=function(x) -payMat(merge(mmVals(c(0,x),strongVal),monoBid(c(0,weakBid),weakVal)),sum=TRUE),method="BFGS",control=cstrong)
  if (!alternate) weakBid <<- alpha*pmin(weakVal[-1],pmax(weakBR$par,0))+(1-alpha)*weakBid
  strongEps<-sum(strongBR$par-strongBid)^2
  strongBid <<- alpha*pmin(strongVal[-1],pmax(strongBR$par,0))+(1-alpha)*strongBid
  plot(c(0,strongBid) ~ strongVal,t="l",ylim=c(0,20))
  lines(c(0,weakBid) ~ weakVal,t="l",col="red")
  lines(c(0,weakEqBid) ~ weakVal,t="l",col="red",lty=3,lwd=2)
  lines(c(0,strongEqBid) ~ strongVal,t="l",col="green",lty=3,lwd=2)
  text(0,20,i)
  x<-rbind(c(weakBid,strongBid))
  write.table(file=file,x,row.names=FALSE,col.names=FALSE,append=TRUE)
}
#
simul <- function(file,n=100,alpha=.5,ndeps=1e-4,alternate=TRUE,w1=30,w2=50) {
   w1<<-w1
   w2<<-w2
   weakVal <<- seq(0,w1,10)
   strongVal <<- seq(0,w2,10)
   weakEqBid  <<- sapply(seq(10,w1,10),function(x) eqWeak(x,w1,w2))
   strongEqBid <<- sapply(seq(10,w2,10),function(x) eqStrong(x,w1,w2))
   weakBid <<- weakEqBid
   strongBid <<- strongEqBid
   unlink(file)
   for (i in 1:n) myStep(file,i,alpha=alpha,ndeps=1e-4,alternate=FALSE);
 }

plotEq <- function(file,type="bids") {
  xx<-read.table(file)
  x<-apply(xx,2,median)
  split<-which(diff(x)<0)
  n<-length(x)
  (w1<-10*split)
  (w2<-(n-split)*10)
  weakVal<-seq(0,w1,10)
  strongVal<-seq(0,w2,10)
  weakEqBid<-sapply(weakVal,eqWeak,w1=w1,w2=w2)
  strongEqBid<-sapply(strongVal,eqStrong,w1=w1,w2=w2)
  weakMedBid<-c(0,x[1:split])
  strongMedBid<-c(0,x[(split+1):n])
  if (type=="bids") {
    par(mar=c(4,4,0,0))
    plot(strongEqBid ~ strongVal,t="l",lty=3,ylab="bid",xlab="valuation",lwd=3)
    lines(weakEqBid ~ weakVal,lty=3,lwd=3)
    lines(weakMedBid ~ weakVal)
    lines(strongMedBid ~ strongVal)
    text(w2/2,0,pos=3,bquote(list(omega[1]==.(w1), omega[2]==.(w2))))
  }
  if (type=="converge") {
    height<-round(sqrt(n))
    width<-ceiling(n/height)
    par(mfcol=c(height,width))
    par(mar=c(2,2,0,0))
    for (i in 1:n) {  plot(xx[,i],t="l");  abline(h=median(xx[,i]))}
    par(mfcol=c(1,1))
  }
}
