### R code from vignette source 'ooExp26c.Rnw'
### Encoding: UTF-8
###################################################
### code chunk number 1: init
###################################################
## the code is already a bit old, so please note the following:
## we have replaced (memisc) aggregate with Aggregate
## we have replaced (car) data.ellipse with dataEllipse 
## we recommend to use lme4-0.999999-2 (more recent versions of lme4 use a different representation of the estimation object and do not contain mcmcsamp).
bootSize<-1000
options(width=60)
load("allBR.Rdata")
allBR <- subset(allBR, substr(allBR$Date,1,6)!="200506")
longBR <- subset(longBR, substr(longBR$Date,1,6)!="200506")
longBR$treattype <- factor(longBR$treattype,levels=c( "no expectations" , "expectations", "expectations w. info","computer opp.","asymmetric"  ))
sidinfo <- unique(data.frame(allBR$sid,allBR$auction_exp_teilnahme))
names(sidinfo)<-c("sid","experience")
longBR <- merge(longBR,sidinfo,by="sid",all.x=TRUE)
longBR <- within(longBR,{
  Dexp<-ifelse(experience=="Ja",1,0)
  treattype <- relevel(treattype,ref="no expectations")
})
#$
library(car)
library(lme4,lib.loc="~/R/lme4") ## we use lme4 prior to 1.0
library(xtable)
library(memisc)
library(robustX)# for BACON
setCoefTemplate(pci=c(est="($est:#)($p:*)", ci="[($lwr:#);($upr:#)]"))
source("optBidIni.R")
source("asymBidInit.R")

###################################################
### code chunk number 2: eqBids
###################################################
par(mar=c(4,4,0,0))
plot(strongContEqBid ~ strongVal,t="l",lty=1,ylab="equilibrium bid",xlab="valuation",lwd=3,cex.lab=1.5)
lines(weakContEqBid ~ weakVal)
lines(strongDiscBid ~ strongVal,lty=2,lwd=3)
lines(weakDiscBid ~ weakVal,lty=2)
#text(w2/2,0,pos=3,bquote(list(omega[1]==.(w1), omega[2]==.(w2))))
legend("bottomright",c("strong, continuous bids","strong, stepw. bids","weak, continuous bids","weak, stepw. bids"),
       lty=c(1,2,1,2),lwd=c(3,3,1,1),bg="white",cex=1.3)


###################################################
### code chunk number 3: exampleBids1
###################################################
brPlot <- function(Subs,refDate) {
  par(mfrow=c(3,3),lwd=3,mar=c(0,0,0,0))
  for (Sub in Subs) {
    plot(NULL,xlim=c(0,60),ylim=c(-10,40))
    with(subset(longBR,Date==refDate & Period==7 & Subject==Sub),{
      lines(bid ~ value)
      lines(exp ~ value,lty=3)
      lines(bestreply ~ value,lty=2)
    })
  }
  plot(NULL,xlim=c(0,60),ylim=c(-10,40))
  legend("center",c("bids","best replies","expectations"),lty=1:3,cex=2,bty="n",bg="white")
}
brPlot(11:18,"20050512-09:01")


###################################################
### code chunk number 4: exampleBids2
###################################################
brPlot(8:15,"20091102-15:59")


###################################################
### code chunk number 6: initStuff
###################################################
averageGain <- signif(with(subset(allBR,Period==NumPeriods),mean(TotalProfit/kurs)),4)
sdGain <- signif(with(subset(allBR,Period==NumPeriods),sd(TotalProfit/kurs)),3)


###################################################
### code chunk number 7: summaryTable
###################################################
expectData<-within(allBR,{DateS<-as.character(indepobs);DateS[treattype=="computer opp."]<-substr(DateS[treattype=="computer opp."],1,13)})
treatlist <- t(sapply(by(expectData,list(expectData$DateS),function(x) with(x,c(as.character(DateS[1]),as.character(treattype[1]),as.character(Place[1]),length(unique(Subject))))),cbind))
treatlist <- treatlist[order(treatlist[,2],treatlist[,1],treatlist[,3]),]
sumTab <- t(sapply(by(expectData,list(expectData$treattype),function(x) with(x,c(indeps=length(unique(indepobs)),subjects=length(unique(sid))))),cbind))
colnames(sumTab)<-c("\\begin{tabular}{c}independent\\\\observations\\end{tabular}","participants")
sumTab <- rbind(sumTab,rbind(apply(sumTab,2,sum)))
rownames(sumTab)[dim(sumTab)[1]]<-"all"


###################################################
### code chunk number 8: summaryTable2
###################################################
print(xtable(sumTab),sanitize.colnames=function(x) x,floating=FALSE,hline.after=c(0,dim(sumTab)[1]-1))


###################################################
### code chunk number 9: figConverge
###################################################
medBid <- with(longBR,aggregate(longBR[,c("overBid")],list(treattype=treattype,Period=Period),function(x) median(abs(x),na.rm=TRUE)))
par(mar=c(4,5,0,0))
plot(NULL,xlim=c(1,12),ylim=c(5,10),xlab="round",ylab=expression(plain(median)*symbol("|")*italic(b)-italic(b)^plain(BNE)*symbol("|")),cex.lab=2)
with(medBid, {
  treatments<-unique(treattype)
  for (t in treatments) lines(x ~ Period,subset=treattype==t,lty=which(t==treatments))
  legend("topright",as.character(treatments),lty=1:length(treatments),cex=1.8)
})


###################################################
### code chunk number 10: figConvergence2
###################################################
xx <- subset(longBR,Period==NumPeriods)[,c("sid","value","bid","exp")]
names(xx)<-sub("(bid|exp)","\\112",names(xx))
xx <- merge(longBR,xx)
xx<-within(xx,{
  biddel <- abs(bid-bid12)
  expdel <- abs(exp-exp12)
})
conv12 <- function(var,ylab) {
  xx3 <- with(xx,aggregate(xx[,var],list(Period=Period,treattype=treattype),median,na.rm=TRUE))
  xx3<-xx3[!is.na(xx3$x),]
  par(mar=c(4,5,0,0))
  plot(NULL,xlim=c(1,12),ylim=range(xx3$x,na.rm=TRUE),xlab="round",ylab=ylab,cex.lab=2)
  with(xx3, {
    treatments<-unique(treattype)
    for (t in treatments) lines(x ~ Period,subset=treattype==t,lty=which(t==treatments))
    legend("topright",as.character(treatments),lty=1:length(treatments),cex=1.8)
  })
}
conv12("biddel",expression(plain(median)*symbol("|")*italic(b)-italic(b)[12]*symbol("|")))


###################################################
### code chunk number 11: figConvergence3
###################################################
conv12("expdel",expression(plain(median)*symbol("|")*italic(b)^plain(exp)-italic(b)[12]^plain(exp)*symbol("|")))


###################################################
### code chunk number 12: figOverbid
###################################################
xx <- with(longBR,aggregate(bid-eqBid,list(treattype=treattype,value=value),median,na.rm=TRUE))
xx<-xx[!is.na(xx$x),]
par(mar=c(4,5,0,0))
plot(NULL,xlim=c(0,60),ylim=range(xx$x,na.rm=TRUE),xlab="value",ylab=expression(plain(median)*(b-b^plain(BNE))),cex.lab=1.5)
with(xx,{
    treatments<-unique(treattype)
  for (t in treatments) lines(x ~ value,subset=treattype==t,lty=which(t==treatments))
  legend("bottomright",as.character(treatments),lty=1:length(treatments),cex=1.5,bg="white")
    abline(h=0,lwd=1)
})


###################################################
### code chunk number 13: treatMer
###################################################
zz <- levels(longBR$treattype)
zz <- cbind(sub("^","treattype",zz),zz)
zz <- rbind(zz,c("eqBid","$\\\\beta^*$"))
treat.mer <- lmer(bid ~  eqBid + treattype + (1|sid) + (1|indepobs),data=longBR)
treat.boot <- mcmcsamp(treat.mer,bootSize)

###################################################
### code chunk number 14: treatMerP
###################################################
quietly <- mer2la(treat.mer,trans=zz,boot=treat.boot)

###################################################
### code chunk number 15: treatMer
###################################################
Dweak <- ifelse(longBR$treattype!="asymmetric",0,longBR$weak)
treatALL.mer <- lmer(bid-exp ~ value + treattype + Dweak + (1|sid) + (1|indepobs),data=longBR)
treat712.mer <- lmer(bid-exp ~ value + treattype + Dweak + (1|sid) + (1|indepobs),data=longBR,subset=Period>6)
treat1_6.mer <- lmer(bid-exp ~ value + treattype + Dweak + (1|sid) + (1|indepobs),data=longBR,subset=Period<=6)
set.seed(3)
estAll <- mtable("all Periods"=treatALL.mer,"Period$\\le6$"=treat1_6.mer,"Period$>6$"=treat712.mer,coef.style="pci",summary.stats=c("Deviance","indep.obs.","participants","N"))


###################################################
### code chunk number 16: treatMerP
###################################################
toLatex(relabel(estAll,value="$\\beta_x$","treattypeexpectations w. info"="with info",treattypeasymmetric="asymmetric",Dweak="weak"))

###################################################
### code chunk number 17: figConsistentExpIni
###################################################
xxs <- with(longBR,aggregate(longBR[,c("bid","exp")],list(value=value,treattype=treattype),median,na.rm=TRUE))
xxa <- with(longBR,aggregate(longBR[,c("bid","exp")],list(value=value,weak=weak,treattype=treattype),median,na.rm=TRUE))
xxe <- within(xxa,{weak<-1-weak;bid<-NULL})
xxa$exp<-NULL
xx <- merge(merge(xxa,xxe),subset(xxs,treattype!="asymmetric"),all=TRUE)
xx$diff <- with(xx,bid-exp)
xx <- xx[!is.na(xx$diff),]
xx <- within(xx,longtreat<-ifelse(is.na(weak),as.character(treattype),ifelse(weak==0,"asymmetric-strong","asymmetric-weak")))
t <- unique(xx$longtreat)


###################################################
### code chunk number 18: figConsistentExp
###################################################
par(mar=c(4,5,0,0),mex=.7,cex=1.5)
with(xx,{
  plot(NULL,ylim=range(exp),xlim=range(bid),xlab="median bid",ylab="median expectation")
  for (treat in t) lines(exp ~ bid,subset=treat==longtreat,lty=which(treat==longtreat),lwd=3)
})
legend("topleft",c(t,"45 degree line"),lty=c(1:length(t),3),lwd=c(replicate(length(t),3),1),bg="white")
abline(a=0,b=1,lty=3)

###################################################
### code chunk number 19: BidsIsExpFreq
###################################################
SBF <- subset(longBR,treattype %in% c("expectations","expectations w. info"))
SBF2 <- Aggregate( c(bidIsExp=min(exp==bid)) ~  sid + Period + treattype, data=SBF)
SBF3 <- Aggregate( c(samebidfrac=mean(bidIsExp,na.rm=TRUE)) ~ Period + treattype,data=SBF2)


###################################################
### code chunk number 20: figBidsIsExpFreq
###################################################
par(mar=c(4,5,0,0),mex=.7,cex=1.5)
with(SBF3,plot(NULL,xlim=range(Period),ylim=range(samebidfrac),xlab="round",ylab="rel. frequency bid=expectation"))
qq<-by(SBF3,list(SBF3[["treattype"]]),function(x) with(x,lines(samebidfrac ~ Period,lty=1+as.integer(treattype[1]=="expectations"))))
legend("topright",c("expectations","expectations w. info"),lty=2:1)


###################################################
### code chunk number 21: figConfIni
###################################################
xx<-with(longBR,aggregate(bid,list(treattype=treattype,value=value,Period=Period),median,na.rm=TRUE))
names(xx)[grep("x",names(xx))]<-"medBid"
xx<-merge(longBR,xx)
xx2 <- subset(xx,!is.na(exp))
xx2$sid<-factor(xx2$sid)
zz <- by(xx2,list(sid=xx2$sid),function(x) c(x$treattype[1],coef(lm(exp ~ medBid,data=x))))
k1exp <- Aggregate(coef(lm(eqExp ~ medBid))~treattype,data=xx2)
k0exp <- Aggregate(coef(lm(value ~ medBid))~treattype,data=xx2)
zz <- as.data.frame(t(sapply(zz,c)))
names(zz)<-c("treattype","beta0","beta1")
tlist <- unique(zz$treattype)


###################################################
### code chunk number 22: figConf
###################################################
layout(rbind(1:3))
par(mex=.5,cex=1.1,mar=c(4,5,3,0))
qq<-by(zz,list(zz$treattype),function(x) with(x,{
  tt<-levels(longBR$treattype)[treattype[1]];
  plot(NULL,xlim=range(zz$beta0),ylim=range(zz$beta1),xlab=expression(beta^0),ylab=expression(beta^1),main=tt);
  dataEllipse(beta0,beta1,levels=.95,robust=TRUE,col="black",pch=3,add=TRUE);
  abline(h=1,v=0,lty=3);
  points(subset(k1exp,treattype==tt)[2:3],pch=8)
  text(subset(k1exp,treattype==tt)[2:3],"equilibrium",pos=4)
  points(subset(k0exp,treattype==tt)[2:3],pch=1)
  text(subset(k0exp,treattype==tt)[2:3],"L1",pos=4)
}))


###################################################
### code chunk number 23: expQual
###################################################
Lag <- function(x) c(NA,x[1:(length(x)-1)])
longBR <-  longBR[with(longBR,order(treattype,sid,value,Period)),]
longBR <- within(longBR,{
  delob<-Lag(c(NA,diff(otherbid)))
  delbid<-c(NA,diff(bid))
  delBR<-c(NA,diff(bestreply))
  delexp<-c(NA,diff(exp))
  delP<-c(NA,diff(Period))
  delPP<-Lag(c(NA,diff(Period)))
  delob[delPP!=1]<-NA
  delbid[delP!=1]<-NA
  delBR[delP!=1]<-NA
  delexp[delP!=1]<-NA
  delP<-NULL
})
feedbackTreat <- subset(with(longBR,aggregate(exp,list(treattype),function(x) mean(is.na(x)))),x<.5 & Group.1 != "expectations")
feedbackTreat<-rename(feedbackTreat,Group.1="treattype")
#
expQual<-merge(longBR,feedbackTreat,by="treattype")
expQual$treattype<-as.character(expQual$treattype)
expQual<-rbind(expQual,within(expQual,treattype<-"all"))
expQual$treattype<-factor(expQual$treattype)
delob.mer <- lmer(delexp ~ delob + (1|sid) + (1|indepobs),data=subset(expQual,treattype=="all"))
delobBid.mer <- lmer(delexp ~ delob + delbid + (1|sid) + (1|indepobs),data=subset(expQual,treattype=="all"))
estAll <- mtable("(\\ref{eq:expOtherbid})"=delob.mer,"(\\ref{eq:expOwnOtherbid})"=delobBid.mer,coef.style="pci",summary.stats=c("Deviance","indep.obs.","participants","N"))
estAll<-relabel(estAll,delob="$\\betaOther$",delbid="$\\betaOwn$")


###################################################
### code chunk number 24: expQual2
###################################################
toLatex(estAll)

###################################################
### code chunk number 25: expInfoMer
###################################################
feedbackTreat <- subset(with(longBR,aggregate(exp,list(treattype),function(x) mean(is.na(x)))),x<.5)
feedbackTreat<-rename(feedbackTreat,Group.1="treattype")
expInfo<-merge(longBR,feedbackTreat,by="treattype")
expInfo$treattype<-as.character(expInfo$treattype)
expInfo$treattype<-factor(expInfo$treattype)

expInfo$Dinfo<-ifelse(expInfo$treattype=="expectations w. info",1,0)
expInfo$DinfoDelBid<-ifelse(expInfo$Dinfo==1,expInfo$delbid,0)
expInfo$delOtherBid<-ifelse(expInfo$Dinfo==1,expInfo$delob,0)

zz1 <- rbind(cbind("Dinfo", "$\\\\delta_0$ (exp. w. info)"),cbind("delbid", "$\\\\beta^{\\\\text{own}}$"),cbind("DinfoDelBid","$\\\\delta^{\\\\text{own}}$ (exp. w. info)"),cbind("delOtherBid","$\\\\beta^{\\\\text{other}}$ (exp. w. info)"))
delExpInfo.mer <- lmer(delexp ~ delbid + Dinfo + DinfoDelBid + delOtherBid + (1|sid) + (1|indepobs),data=subset(expInfo,treattype=="expectations w. info"|treattype=="expectations"))
delExpInfo.boot <- mcmcsamp(delExpInfo.mer,bootSize)


###################################################
### code chunk number 26: expInfoMerP
###################################################
quietly <- mer2la(delExpInfo.mer,trans=zz1,boot=delExpInfo.boot)

###################################################
### code chunk number 27: similarMer
###################################################
xx<-with(longBR,aggregate(bid,list(treattype=treattype,value=value,Period=Period),median,na.rm=TRUE))
names(xx)[grep("x",names(xx))]<-"medBid"
xx<-merge(longBR,xx)
xx$dExp2Bid<-xx$exp-xx$medBid
xx$dExp2Bid<-ifelse(xx$dExp2Bid<0,-xx$dExp2Bid,xx$dExp2Bid)
zz <- levels(xx$treattype)
zz <- cbind(sub("^","treattype",zz),zz)
similar.mer <- lmer(dExp2Bid ~  treattype + (1|sid) + (1|indepobs),data=subset(xx,xx$treattype=="expectations"|xx$treattype=="expectations w. info"))
similar.boot <- mcmcsamp(similar.mer,bootSize)

###################################################
### code chunk number 28: similarMerP
###################################################
quietly <- mer2la(similar.mer,trans=zz,boot=similar.boot)

###################################################
### code chunk number 29: qualityReactionToExpectationIni
###################################################
qualReact <- subset(longBR,!is.na(delBR))
qualReact$sid<-factor(qualReact$sid)
zz <- by(qualReact,list(sid=qualReact$sid),function(x) with(x,c(treattype[1],coef(lm(delbid ~ delBR)))))
zz <- as.data.frame(t(sapply(zz,c)))
names(zz)<-c("treattype","beta0","beta1")
zz<-within(zz,beta1[is.na(beta1)]<-0)
zz2 <- subset(zz,BACON(zz[,2:3],verbose=FALSE)$subset)
tlist <- unique(zz2$treattype)


###################################################
### code chunk number 30: qualityReactionToExpectation
###################################################
par(mar=c(4,5,0,0))
with(zz2,plot(NULL,xlim=range(beta0),ylim=range(beta1),xlab=expression(beta[0]),ylab=expression(beta[Delta]^list(plain(opt)*symbol("|")*plain(exp))),cex.lab=1.5))
qq <- by(zz2,list(zz2$treattype),function(x) with(x,{ii<-which(x$treattype[1]==tlist);dataEllipse(beta0,beta1,levels=.95,add=TRUE,robust=TRUE,col="black",lty=ii,pch=ii)}))
abline(h=c(0,1),v=0,lty=3)
legend("topright",c(levels(qualReact$treattype)[tlist]),lty=c(1:length(tlist),1),pch=c(1:length(tlist),NA),bg="white",cex=1.3)


###################################################
### code chunk number 31: qualReact2
###################################################
qualReact$treattype<-as.character(qualReact$treattype)
qualReact<-rbind(qualReact,within(qualReact,treattype<-"all"))
qualReact$treattype<-factor(qualReact$treattype)
estAll <- mtable(By(~treattype,lmer(delbid ~ delBR + (1|sid) + (1|indepobs)),data=qualReact),coef.style="pci",summary.stats=c("Deviance","indep.obs.","participants","N"))
estAll<-relabel(estAll,delBR="$\\dbOpt$")


###################################################
### code chunk number 32: qualReact3
###################################################
toLatex(estAll)

###################################################
### code chunk number 33: bidOverview
###################################################
xx <-within(longBR,{tt=as.character(treattype);tt[treattype=="asymmetric"]<-ifelse(weak[treattype=="asymmetric"],"asymmetric-weak","asymmetric-strong")})
xx<-with(xx,aggregate(xx[,c("bid","exp","bestreply","eqBid")],list(treattype=tt,value=value),median,na.rm=TRUE))
xx2 <- xx[grep("asymmetric",xx$treattype),c("treattype","value","exp")]
names(xx2)[3]<-"exp.o"
xx <- merge(xx,within(xx2,treattype<-ifelse(treattype=="asymmetric-strong","asymmetric-weak","asymmetric-strong")),all.x=TRUE)
mm <- grep("asymmetric",xx$treattype)
xx$exp[mm]<-xx$exp.o[mm]
par(mfrow=c(2,3),mar=c(0,0,0,0))
By(~treattype,{plot(value,bid,ylim=c(-10,45),xlim=c(0,60),t="l")
               lines(value,exp,lty=2)
               lines(value,bestreply,lty=4)
               lines(value,eqBid,lty=3)
               lines(value,value,lty=3,lwd=2)
               text(5,40,treattype[1],adj=c(0,1),cex=1.5)
               text(50,-10,"value",adj=c(1,.5))
               text(0,30,"bid",adj=c(1,1),srt=90)
             },data=xx)
legend("bottomright",c("bid","expect","best reply","equil.","45 deg."),lty=c(1,2,4,3,3),lwd=c(1,1,1,1,2),cex=1.5,bg="white")


###################################################
### code chunk number 34: diffBidExp
###################################################
plotDiffBid <- function (aveAD,xlim=range(aveAD$x,na.rm=TRUE),xlab=NULL,main=NULL) {
  aveAD <- subset(aveAD,!is.na(x))
  treatments<-unique(aveAD$treattype)
  plot(NULL,xlim=xlim,ylim=c(0,1),xlab=xlab,ylab="F(x)",main=main)
  lwds=c(3,1,1,1)
  for (t in treatments) with(subset(aveAD,treattype==t),  {
    ti<-which(t==treatments);
    lines(ecdf(x),lty=ti,do.points=FALSE,verticals=TRUE,lwd=lwds[ti]) 
  })
  legend("bottomright",as.character(treatments),lwd=lwds,lty=1:length(treatments),bg="white")
}
longBR <- subset(longBR,longBR[["Period"]]>=1)
xx<-with(longBR,aggregate(bid,list(treattype=treattype,value=value,Period=Period),median,na.rm=TRUE))
names(xx)[grep("x",names(xx))]<-"medBid"
xx<-merge(longBR,xx)
xx <- within(xx,distexp<-abs(exp-medBid))
aveADE <- with(xx,aggregate(distexp,list(sid=sid,treattype=treattype),mean,na.rm=TRUE))
#
longBR <- within(longBR,distbr<-abs(bid-bestreply))
aveADB <- with(longBR,aggregate(distbr,list(sid=sid,treattype=treattype),mean,na.rm=TRUE))
xlim <- quantile(c(aveADE$x,aveADB$x),c(.01,.99),na.rm=TRUE)


###################################################
### code chunk number 35: exps2medBid
###################################################
par(mar=c(4,5,4,0),mex=.5,cex=1.3,mfrow=c(1,2))
plotDiffBid(aveADE,xlim=xlim,xlab=expression(plain(average)[i]*(symbol("|")*plain(expectation-median~bid)*symbol("|"))),main="Expected bids vs Median bids")
plotDiffBid(aveADB,xlim=xlim,xlab=expression(plain(average)[i]*(symbol("|")*plain(bid-best~reply)*symbol("|"))),main="Bids vs Best replies given exp. bids")


###################################################
### code chunk number 36: bOptBNE0
###################################################
xx <- within(subset(longBR,!is.na(bestreply)),sid<-factor(sid))
bOptBNW<- t(sapply(by (xx,list(xx$sid),function(x)c(treattype=x$treattype[1],coef(lm(bestreply~eqBid,data=x)))),c))
bActOpt<- t(sapply(by (xx,list(xx$sid),function(x)c(treattype=x$treattype[1],coef(lm(bid~bestreply,data=x)))),c))


###################################################
### code chunk number 37: bOptBNE
###################################################
par(mar=c(4,5,0,0))
plot(NULL,xlim=range(bOptBNW[,2]),ylim=range(bOptBNW[,3]),xlab=expression(beta[0]^plain(BNE)),ylab=expression(beta^plain(BNE)),cex.lab=1.5)
abline(h=1,v=0,lty=3)
qq<-by(bOptBNW,list(bOptBNW[,"treattype"]),function(x) dataEllipse(x[,2],x[,3],levels=.95,add=TRUE,robust=TRUE,col="black",pch=x[1,1]-1,lty=x[1,1]-1))
tt<-unique(bOptBNW[,"treattype"])
legend("bottomleft",levels(longBR$treattype)[tt],lty=tt-1,pch=tt-1,bg="white",cex=1.5)


###################################################
### code chunk number 38: bActOpt
###################################################
par(mar=c(4,5,0,0))
plot(NULL,xlim=range(bActOpt[,2]),ylim=range(bActOpt[,3]),xlab=expression(beta[0]^list(plain(opt)*symbol("|")*plain(exp))),ylab=expression(beta^list(plain(opt)*symbol("|")*plain(exp))),cex.lab=1.5)
abline(h=1,v=0,lty=3)
qq<-by(bActOpt,list(bActOpt[,"treattype"]),function(x) dataEllipse(x[,2],x[,3],levels=.95,add=TRUE,robust=TRUE,col="black",pch=x[1,1]-1,lty=x[1,1]-1))
tt<-unique(bActOpt[,"treattype"])
legend("bottomleft",levels(longBR$treattype)[tt],lty=tt-1,pch=tt-1,bg="white",cex=1.5)


###################################################
### code chunk number 39: bOptBNEme0
###################################################
subLongBR <- subset(longBR,!is.na(bestreply))
subLongBR <- rbind(subLongBR,within(subLongBR,treattype<-"all"))
subLongBR <- within(subLongBR,treattype<-factor(treattype))
estbOpt <- mtable(By(~treattype,lmer(bestreply ~ eqBid + (1|sid) + (1|indepobs)),data=subLongBR),coef.style="pci",summary.stats=c("Deviance","indep.obs.","participants","N"))
estbOpt<-relabel(estbOpt,eqBid="$\\betaBNE$","(Intercept)"="$\\betaBNEO$")
#
estBAct <- mtable(By(~treattype,lmer(bid ~ bestreply + (1|sid) + (1|indepobs)),data=subLongBR),coef.style="pci",summary.stats=c("Deviance","indep.obs.","participants","N"))
estBAct<-relabel(estBAct,bestreply="$\\betaOpt$","(Intercept)"="$\\betaOptO$")


###################################################
### code chunk number 40: bOptBNEme
###################################################
toLatex(estbOpt)


###################################################
### code chunk number 41: bActOptme
###################################################
toLatex(estBAct)


###################################################
### code chunk number 42: levelkPlotp
###################################################
longBR <- within(longBR,{
  cens  <-treattype=="asymmetric" & weak==0 & value>40
  bL0   <-abs(bid-value)
  eL1exp<-abs(exp-value)
  bL1bid<-abs(bid-value/2)
  eL2exp<-abs(exp-value/2)
  bL2bid<-abs(bid-value/2)
  bL2bid[cens]<-abs(bid[cens]-20)
  cens  <-NULL
  })
aveL012 <- with(longBR,aggregate(longBR[,c("bL0","eL1exp","bL1bid","eL2exp","bL2bid")],list(sid=sid,treattype=treattype),mean,na.rm=TRUE))
aveL012 <- subset(aveL012,!is.na(eL1exp))
treatments<-unique(aveL012$treattype)
maxL <- max(aveL012[,grep("L",names(aveL012))])
with(aveL012,{avL0 <<- signif(median(bL0),3)
#     avL1 <<- signif(median(sqrt(eL1exp^2 + bL1bid^2)),3)
#     avL2 <<- signif(median(sqrt(eL2exp^2 + bL2bid^2)),3)
     avL1 <<- signif(median(bL1bid),3)
     avL2 <<- signif(median(bL2bid),3)
            })


###################################################
### code chunk number 43: levelkPlot
###################################################
layout(rbind(1:3))
par(mar=c(4,5.5,0,0),mex=.5,cex=1.1)
avDiff <- function (what,level) parse(text=sprintf("plain(average)[i]*(symbol('|')*plain(%s-L%d[%s])*symbol('|'))",what,level,what))
with(aveL012,plot(NULL,xlim=c(0,maxL),ylim=c(0,1),xlab=avDiff("bid",0),ylab="F(x)"))
for (t in treatments) with(subset(aveL012,treattype==t),plot(ecdf(bL0),lty=which(t==treatments),do.points=FALSE,verticals=TRUE,add=TRUE))
  legend("bottomright",as.character(treatments),lty=1:length(treatments))
plot(eL1exp ~ bL1bid,data=aveL012,xlim=c(0,maxL),ylim=c(0,maxL),pch=as.integer(treattype)-1,xlab=avDiff("bid",1),ylab=avDiff("exp",1))
legend("bottomright",as.character(treatments),pch=as.integer(treatments)-1)
plot(eL2exp ~ bL2bid,data=aveL012,xlim=c(0,maxL),ylim=c(0,maxL),pch=as.integer(treattype)-1,xlab=avDiff("bid",2),ylab=avDiff("exp",2))
legend("bottomright",as.character(treatments),pch=as.integer(treatments)-1)


###################################################
### code chunk number 44: treatlist0
###################################################
colnames(treatlist)<-c("date","treatment","place","participants")
x.big <- xtable(treatlist,label='treatlist',caption='List of All Sessions')


###################################################
### code chunk number 45: treatlist
###################################################
print(x.big,include.rownames=FALSE,tabular.environment='longtable',floating=FALSE)


###################################################
### code chunk number 46: expOtherbid0
###################################################
estOther <- mtable(By(~treattype,lmer(delexp ~ delob + (1|sid) + (1|indepobs)),data=expQual),coef.style="pci",summary.stats=c("Deviance","indep.obs.","participants","N"))
estOther<-relabel(estOther,delob="$\\betaOther$")


###################################################
### code chunk number 47: expOtherbid
###################################################
toLatex(estOther)


###################################################
### code chunk number 48: expOwnOtherbid
###################################################
estOwnOther <- mtable(By(~treattype,lmer(delexp ~ delob + delbid + (1|sid) + (1|indepobs)),data=expQual), coef.style="pci",summary.stats=c("Deviance","indep.obs.","participants","N"))
estOwnOther<-relabel(estOwnOther,delob="$\\betaOther$",delbid="$\\betaOwn$")


###################################################
### code chunk number 49: expOwnOtherbid
###################################################
toLatex(estOwnOther)


