#
zTreeSbj <- function(files) {
  sbj<-NULL
  for (filename in files) {
    cat("reading ",filename,"...\n")
    Tfile<-file(filename,"r")
    aa<-readLines(Tfile)
    close(Tfile)
    aa2<-strsplit(aa,"\t")
    N <- length(aa2[[2]])-1
    aa3<-as.data.frame(list(Date=rep(sub(".sbj$","",sub(".*/","",filename)),N)))
    lapply(aa2,function(x) if (length(x)==N+1) aa3[[x[1]]]<<- x[-1]) 
    sbj<-merge(sbj,aa3,all=TRUE)
  }
  sbj
}
#
toLongDate <- function (shortDate) {
  sapply(as.character(shortDate),function(zz) {
    pre <- ifelse(substr(zz,1,2)<"80","20","19")
    if (nchar(zz)==8) {
#      hour  <- which(LETTERS==substr(zz,7,7))-1
      minute<- 60*which(LETTERS==substr(zz,7,7)) + (which(c(as.character(0:9),LETTERS)==substr(zz,8,8)))*2 - 21
      sprintf("%s%s-%02d:%02d",pre,substr(zz,1,6),minute%/%60,minute%%60)
    }
    else if (nchar(zz)==11) sprintf("%s%s-%s:%s",pre,substr(zz,1,6),substr(zz,8,9),substr(zz,10,11))
    else zz
  })
}
#
mer2ctab <- function (mer,relimp=FALSE,type="pmvd",boot=NULL) {
  ctab <- summary(mer)@coefs
  if (!is.null(boot)) {
    ctab[,"Std. Error"] <- apply(boot@fixef,1,sd)
    ctab[,"t value"] <-  ctab[,"Estimate"] / ctab[,"Std. Error"]
  }
  if (length(colnames(ctab))==4) {
    ctab <- cbind(ctab, ctab[,"Estimate"] +   cbind(ctab[,"Std. Error"]*abs(qnorm(.025))) %*% c(-1,1))
  } else {
    df <- mer@dims["n"]-mer@dims["q"]-mer@dims["p"]+1
    ctab <- cbind(ctab,2*pt(-abs(ctab[,"t value"]),df=df))
    ctab <- cbind(ctab, ctab[,"Estimate"] +   cbind(ctab[,"Std. Error"]*abs(qt(.025,df=df))) %*% c(-1,1))
  }
  colnames(ctab)[4:6]=c("p value","confsub","confsup")
  ctab<-as.data.frame(ctab)
  if (relimp) {
    rownames(ctab)<-sub("TRUE","",rownames(ctab))
    lmformula <- paste(sapply(c(2,3),function(i) attr(mer@frame,"terms")[[i]]),collapse="~")
    mer.lm <- lm(lmformula,data=mer@frame)
    relimp <- eval(parse(text=sprintf("calc.relimp(mer.lm,type='%s',rela=TRUE)@%s",type,type)))
    ctab[[type]]<-NA
    for(name in names(relimp)) ctab[name,type]<-relimp[name]
  }
  ctab
}

mer2la <- function (mer=NULL,ctab=NULL,trans=NULL,relimp=FALSE,type="pmvd",strip=NULL,boot=NULL) {
  if (is.null(ctab)) ctab <- mer2ctab(mer,relimp=relimp,type=type,boot=boot)
  relimp=dim(ctab)[2]==7
  if(relimp) type=colnames(ctab)[7]
  cc <- ctab
  if (!is.null(strip)) {
    delVec <- grep(strip,rownames(ctab))
    delVec2 <- delVec[ctab[delVec,type]<.05]
    if (length(delVec2)>0) {
      ctab <- ctab[-delVec2,]
      if(relimp) ctab["other",type]<-1-sum(ctab[,type],na.rm=TRUE)
    }
  }
  colnames(ctab)[1:2]=c("$\\beta$","$\\sigma$")
  colnames(ctab)[4:6]=c("$p$ value","95\\% conf","interval")
  #if (relimp) colnames(ctab)[7]=c("pmvd")
  colnames(ctab)[colnames(ctab)=="t value"]<-"$t$"
  colnames(ctab)[colnames(ctab)=="z value"]<-"$z$"
  if (length(dim(trans))==2) {
    rn <- rownames(ctab)
    rn <- sub("TRUE$","",rn)
    apply(trans,1,function(x) {rn<<-sub(paste("^",x[1],"$",sep=""),x[2],rn);})
    rownames(ctab)<-rn
  }
  if (relimp)
    print(xtable(ctab,digits=c(1,3,3,3,4,3,3,3),display=c("fg","fg","fg","fg","f","fg","fg","f"),align="l||c|c|c|c|cc|c"),floating=FALSE,sanitize.colnames.function = function(x) x,sanitize.rownames.function = function(x) x)
  else
    print(xtable(ctab,digits=c(1,3,3,3,4,3,3),display=c("fg","fg","fg","fg","f","fg","fg"),align="l||c|c|c|c|cc|"),floating=FALSE,sanitize.colnames.function = function(x) x,sanitize.rownames.function = function(x) x)
  cc
}
#
getSummary.mer <- function(mer) {
  msd <- sqrt(diag(vcov(mer)))
  coefs <- fixef(mer)
  mz<-mcmcsamp(mer,bootSize)
  mf <- mz@fixef
  mzp <- 2*pnorm(-abs(mzt <- (mzcoef <- apply(mf,1,mean))/(mzsd <- apply(mf,1,sd))))
  mzci <- cbind(coefs) %*% c(1,1) + cbind(mzsd) %*% rbind(qnorm(c(.025,.975)))
  coef <- cbind(coefs,mzsd,mzt,mzp,mzci)
  colnames(coef) <- c("est", "se", "stat", "p", "lwr", "upr")
  smer<-summary(mer)
  AIC <- smer@AICtab$AIC
  BIC <- smer@AICtab$BIC
  logLik <- smer@AICtab$logLik
  deviance <- smer@AICtab$deviance
  REMSdev <- smer@AICtab$REMSdev
  N <- length(mer@resid)
  # below we assume two random effects: one for the independent observations and one for the participants
  # this is frequently the case for experiments but need not always be the case for other mer-s
  ngrps<-min(smer@ngrps)
  mgrps<-max(smer@ngrps)
  sumstat <- c(deviance=deviance,AIC=AIC,BIC=BIC,logLik=logLik,N=N,ngrps=ngrps,mgrps=mgrps)
  list(coef=coef,sumstat=sumstat,call = mer@call)
}
setSummaryTemplate(mer=c("Log-likelihood" = "($logLik:f#)",
                     Deviance      = "($deviance:f#)",
                     AIC           = "($AIC:f#)",
                     BIC           = "($BIC:f#)",
                     N             = "($N:d)",
                     "indep.obs."="($ngrps:d)",
                     "participants"="($mgrps:d)"))
#
